<?php

/* --------------------------------------------------------------
   ContentAllowRobotsStatus.inc.php 2019-04-12
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2019 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

/**
 * Class ContentAllowRobotsStatus
 *
 * This class represents the content "allow robots" status
 *
 * @category   System
 * @package    Content
 */
class ContentAllowRobotsStatus implements ContentAllowRobotsStatusInterface
{
    /**
     * Content "allow robots" status
     *
     * @var bool
     */
    protected $allowRobots;
    
    
    /**
     * ContentAllowRobotsStatus constructor
     *
     * @param bool $allowRobots Content "allow robots" status
     */
    public function __construct(bool $allowRobots = true)
    {
        $this->allowRobots = $allowRobots;
    }
    
    
    /**
     * Return the content "allow robots" status
     *
     * @return bool
     */
    public function isAllowed(): bool
    {
        return $this->allowRobots;
    }
}